#region References

using System;
using System.Collections;
using System.Text;
using System.Timers;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;

#endregion

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// **** 508 Compliance ***
	/// </summary>
	public class VbecsErrorProvider : ErrorProvider
	{
		/// <summary>
		/// Used to store the active error messages for the form
		/// </summary>
		private Hashtable _errorMessages = null;

		/// <summary>
		/// This method replaces SetError so that we may audibilize the Error Provider message 
		/// for visually impaired users.  If the user is not visually impaired this method
		/// behaves the same as SetError().
		/// </summary>
		/// <param name="control"></param>
		/// <param name="value"></param>
		public void SetVbecsError ( Control control, String value )
		{
			if( Common.LogonUser.IsVisuallyImpairedUser )
			{
				if ( this._errorMessages == null )
				{
					this._errorMessages = new Hashtable();
				}
				//
				if ( (value == null || value == string.Empty || value.Length == 0) 
					&& this._errorMessages.Count > 0 )
				{
					// Remove error message for the control provided
					if ( this._errorMessages.Contains(control) )
					{
						this._errorMessages.Remove(control);
					}
				}
				else if (value != null && value != string.Empty && value.Length > 0)
				{
					// Add new error message if not already in the table
					if ( !this._errorMessages.Contains(control) )
					{
						this._errorMessages.Add(control, value);
					}
				}
			}
			//
			this.SetError( control, value );
		}

		/// <summary>
		/// Get the error messages active for the form
		/// </summary>
		/// <returns></returns>
		public string GetErrorMessages()
		{
			string returnMessage = string.Empty;
			//
			if ( this._errorMessages != null && this._errorMessages.Count > 0 )
			{
				StringBuilder messages = new StringBuilder();
				//
				IDictionaryEnumerator innerEnumerator = this._errorMessages.GetEnumerator();
				//
				while ( innerEnumerator.MoveNext() )
				{
					messages.Append("\n");
					messages.Append(innerEnumerator.Value);
				}
				//
				returnMessage = messages.ToString();
			}
			//
			return returnMessage;
		}

	}
}
